/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import javax.swing.JFrame;
import com.inet.viewer.ActionPool;
import com.inet.viewer.SwingReportViewer;
import com.inet.viewer.ToolBar;

/**
 * This is a quick example of how simply you can remove any actions and buttons from the i-net Clear Reports viewer,
 * starting in version 7.0. This will create an empty Viewer and remove its Info Button, disabling the Info action,
 * which normally would display an info dialog.
 */
public class RemoveToolbarAction {

    // Note that the new Viewer cannot be added to an AWT Frame.
    private static JFrame frame = new JFrame( "i-net Clear Reports Viewer" );

    /**
     * Removes the info button from the Java viewer.
     */
    public static void initGUI() {
        frame.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );

        // Here we create our Viewer instance
        final SwingReportViewer viewer = new SwingReportViewer();

        ToolBar toolbar = viewer.getToolBar();

        // using the setButtonsVisible method, we are able to remove any button we choose.
        toolbar.setButtonsVisible( ToolBar.BUTTON_INFO, false );

        // however, note that this did not disable the action - F1 would still show the info dialog, unless we
        // also disable the action itself. This is done by referencing the Viewer's ActionPool, getting the ViewerAction
        // we want to disable and simply disabling it:
        viewer.getActionPool().getViewerAction( ActionPool.INFO ).setEnabled( false );

        frame.getContentPane().add( viewer );

        //Display the window.
        frame.pack();

        frame.setVisible( true );

    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        initGUI();
    }
}
